
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Minimize Work Hours")

    # Create variables
    jean_hours = model.addVar(name="jean_hours", lb=0.0)  # Non-negative
    ringo_hours = model.addVar(name="ringo_hours", lb=0.0) # Non-negative

    # Set objective function
    model.setObjective(3.51 * jean_hours + 7.43 * ringo_hours, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(6 * jean_hours + 21 * ringo_hours >= 44, "organization_score_min")
    model.addConstr(13 * jean_hours + 10 * ringo_hours >= 46, "likelihood_to_quit_min")
    model.addConstr(9 * jean_hours + 8 * ringo_hours >= 16, "work_quality_min")
    model.addConstr(3 * jean_hours - 4 * ringo_hours >= 0, "jean_ringo_ratio")
    model.addConstr(6 * jean_hours + 21 * ringo_hours <= 113, "organization_score_max")
    model.addConstr(13 * jean_hours + 10 * ringo_hours <= 126, "likelihood_to_quit_max")
    model.addConstr(9 * jean_hours + 8 * ringo_hours <= 65, "work_quality_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by Jean: {jean_hours.x}")
        print(f"Hours worked by Ringo: {ringo_hours.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
