
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(name="hours_worked_by_Jean", lb=0)
x2 = m.addVar(name="hours_worked_by_Ringo", lb=0)

# Set the objective function
m.setObjective(3.51*x1 + 7.43*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(6*x1 + 21*x2 >= 44, name="min_org_score")
m.addConstr(6*x1 + 21*x2 <= 113, name="max_org_score")
m.addConstr(13*x1 + 10*x2 >= 46, name="min_quit_index")
m.addConstr(13*x1 + 10*x2 <= 126, name="max_quit_index")
m.addConstr(9*x1 + 8*x2 >= 16, name="min_work_quality")
m.addConstr(9*x1 + 8*x2 <= 65, name="max_work_quality")
m.addConstr(3*x1 - 4*x2 >= 0, name="additional_constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Jean: {x1.x}")
    print(f"Hours worked by Ringo: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
