
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_Jean', lb=0)  # No lower bound specified, assuming 0
    x2 = model.addVar(name='hours_worked_by_Ringo', lb=0)  # No lower bound specified, assuming 0

    # Define the objective function
    model.setObjective(3.51 * x1 + 7.43 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(6 * x1 + 21 * x2 >= 44)
    model.addConstr(13 * x1 + 10 * x2 >= 46)
    model.addConstr(9 * x1 + 8 * x2 >= 16)
    model.addConstr(3 * x1 - 4 * x2 >= 0)
    model.addConstr(6 * x1 + 21 * x2 <= 113)
    model.addConstr(13 * x1 + 10 * x2 <= 126)
    model.addConstr(9 * x1 + 8 * x2 <= 65)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Hours worked by Jean: {x1.varValue}')
        print(f'Hours worked by Ringo: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
