
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_model")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x3")
x4 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x4")
x5 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x5")
x6 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x6")


# Set objective function
m.setObjective(2*x0*x1 + 6*x0*x4 + 7*x1*x3 + 9*x1*x5 + 3*x1*x6 + x2*x6 + 5*x3*x5 + 4*x4**2 + 5*x4*x6 + x5*x6 + 4*x0 + 2*x1 + x2 + 6*x3 + 9*x4 + 9*x6, GRB.MINIMIZE)

# Add constraints
m.addConstr(11*x0 + 9*x1 + 11*x2 + 9*x3 + 10*x4 + 3*x5 + 9*x6 <= 132)
m.addConstr(8*x0 + 4*x1 + 10*x2 + 5*x3 + 2*x4 + 8*x5 + 6*x6 <= 336)
m.addConstr(x0 + 2*x1 + 6*x2 + 6*x3 + 11*x4 + 5*x5 + 11*x6 <= 199)
m.addConstr(9*x0 + 10*x1 + 7*x2 + 9*x3 + x4 + 6*x5 + 11*x6 <= 149)
# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

