
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
dale = m.addVar(vtype=GRB.INTEGER, name="dale")
hank = m.addVar(vtype=GRB.CONTINUOUS, name="hank")
george = m.addVar(vtype=GRB.INTEGER, name="george")
bobby = m.addVar(vtype=GRB.INTEGER, name="bobby")
laura = m.addVar(vtype=GRB.INTEGER, name="laura")


# Set objective function
m.setObjective(3.39*dale**2 + 4.91*dale*hank + 6.53*dale*george + 7.29*dale*bobby + 8.13*dale*laura + 7.6*hank**2 + 9.61*hank*george + 6.55*hank*laura + 9.68*george**2 + 4.11*george*bobby + 9.08*george*laura + 9.4*laura**2 + 2.71*dale + 7.89*george + 9.21*bobby + 5.64*laura, GRB.MINIMIZE)

# Add constraints
m.addConstr(bobby + laura >= 18)
m.addConstr(dale**2 + george**2 >= 14)
m.addConstr(hank + laura >= 23)
m.addConstr(hank + bobby >= 24)
m.addConstr(dale + bobby >= 18)
m.addConstr(dale + hank + george + bobby + laura >= 18)
m.addConstr(12*dale**2 + 10*hank**2 >= 39)
m.addConstr(12*dale + 2*george >= 45)
m.addConstr(12*dale + 12*bobby >= 30)
m.addConstr(12*dale**2 + 10*hank**2 + 2*george**2 >= 37)
m.addConstr(12*dale + 10*hank + 12*bobby >= 37)
m.addConstr(10*hank + 12*bobby + 7*laura >= 37)
m.addConstr(12*dale**2 + 10*hank**2 + 2*george**2 >= 33)
m.addConstr(12*dale + 10*hank + 12*bobby >= 33)
m.addConstr(10*hank + 12*bobby + 7*laura >= 33)
m.addConstr(12*dale + 10*hank + 2*george >= 41)
m.addConstr(12*dale + 10*hank + 12*bobby >= 41)
m.addConstr(10*hank + 12*bobby + 7*laura >= 41)
m.addConstr(12*dale + 10*hank + 2*george + 12*bobby + 7*laura >= 41)
m.addConstr(4*dale - 7*george >= 0)
m.addConstr(-9*george + 8*bobby >= 0)
m.addConstr(bobby + laura <= 107)
m.addConstr(dale**2 + hank**2 + george**2 <= 135)
m.addConstr(dale**2 + hank**2 + laura**2 <= 83)
m.addConstr(george + bobby + laura <= 52)
m.addConstr(dale + bobby + laura <= 129)
m.addConstr(dale + george + bobby <= 120)
m.addConstr(hank + george + laura <= 113)
m.addConstr(hank + george + bobby <= 129)
m.addConstr(dale + george + laura <= 78)
m.addConstr(hank + bobby + laura <= 94)
m.addConstr(12*dale**2 + 10*hank**2 + 7*laura**2 <= 106)
m.addConstr(12*dale + 10*hank + 2*george <= 189)
m.addConstr(12*dale + 2*george + 12*bobby <= 93)
m.addConstr(10*hank**2 + 2*george**2 + 12*bobby**2 <= 148)
m.addConstr(10*hank + 12*bobby + 7*laura <= 234)
m.addConstr(12*dale**2 + 2*george**2 + 7*laura**2 <= 202)
m.addConstr(2*george + 12*bobby + 7*laura <= 135)


# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

