
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by Dale
x1 = m.addVar(name="x1")  # hours worked by Hank
x2 = m.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # hours worked by George
x3 = m.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # hours worked by Bobby
x4 = m.addVar(name="x4", vtype=gurobi.GRB.INTEGER)  # hours worked by Laura

# Objective function
m.setObjective(3.39*x0**2 + 4.91*x0*x1 + 6.53*x0*x2 + 7.29*x0*x3 + 8.13*x0*x4 + 
               7.6*x1**2 + 9.61*x1*x2 + 6.55*x1*x4 + 9.68*x2**2 + 4.11*x2*x3 + 
               9.08*x2*x4 + 9.4*x4**2 + 2.71*x0 + 7.89*x2 + 9.21*x3 + 5.64*x4, 
               gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(x3 + x4 >= 18)
m.addConstr(x0**2 + x2**2 >= 14)
m.addConstr(6*x1 + x4 >= 23)
m.addConstr(6*x1 + x3 >= 24)
m.addConstr(x0 + x3 >= 18)
m.addConstr(x0 + x1 + x2 + x3 + x4 >= 18)
m.addConstr(12*x0**2 + 10*x1**2 >= 39)
m.addConstr(12*x0 + 2*x2 >= 45)
m.addConstr(12*x0 + 12*x3 >= 30)
m.addConstr(12*x0**2 + 10*x1**2 + 2*x2**2 >= 37)
m.addConstr(12*x0 + 10*x1 + 12*x3 >= 37)
m.addConstr(10*x1 + 12*x3 + 7*x4 >= 37)
m.addConstr(12*x0**2 + 10*x1**2 + 2*x2**2 >= 33)
m.addConstr(12*x0 + 10*x1 + 12*x3 >= 33)
m.addConstr(10*x1 + 12*x3 + 7*x4 >= 33)
m.addConstr(12*x0 + 10*x1 + 2*x2 >= 41)
m.addConstr(12*x0 + 10*x1 + 12*x3 >= 41)
m.addConstr(10*x1 + 12*x3 + 7*x4 >= 41)
m.addConstr(12*x0 + 10*x1 + 2*x2 + 12*x3 + 7*x4 >= 41)
m.addConstr(4*x0 - 7*x2 >= 0)
m.addConstr(-9*x2 + 8*x3 >= 0)
m.addConstr(x3 + x4 <= 107)
m.addConstr(x0**2 + 6*x1**2 + 12*x2**2 <= 135)
m.addConstr(x0**2 + 6*x1**2 + x4**2 <= 83)
m.addConstr(x2 + x3 + x4 <= 52)
m.addConstr(x0 + x3 + x4 <= 129)
m.addConstr(x0 + x2 + x3 <= 120)
m.addConstr(6*x1 + 12*x2 + x4 <= 113)
m.addConstr(6*x1 + 12*x2 + x3 <= 129)
m.addConstr(x0 + x2 + x4 <= 78)
m.addConstr(6*x1 + x3 + x4 <= 94)
m.addConstr(12*x0**2 + 10*x1**2 + 7*x4**2 <= 106)
m.addConstr(12*x0 + 10*x1 + 2*x2 <= 189)
m.addConstr(12*x0 + 2*x2 + 12*x3 <= 93)
m.addConstr(10*x1**2 + 2*x2**2 + 12*x3**2 <= 148)
m.addConstr(10*x1 + 12*x3 + 7*x4 <= 234)
m.addConstr(12*x0**2 + 2*x2**2 + 7*x4**2 <= 202)
m.addConstr(2*x2 + 12*x3 + 7*x4 <= 135)

# Optimize
m.optimize()

# Print solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
else:
    print("No solution found")
