
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
yellow_highlighters = model.addVar(vtype=gp.GRB.INTEGER, name="yellow_highlighters")
red_pens = model.addVar(vtype=gp.GRB.INTEGER, name="red_pens")
color_printers = model.addVar(vtype=gp.GRB.INTEGER, name="color_printers")
paper_clips = model.addVar(vtype=gp.GRB.INTEGER, name="paper_clips")
smoke_detectors = model.addVar(vtype=gp.GRB.INTEGER, name="smoke_detectors")
rubber_bands = model.addVar(vtype=gp.GRB.INTEGER, name="rubber_bands")


# Set objective function
model.setObjective(6*yellow_highlighters + 3*red_pens + 3*color_printers + 5*paper_clips + 9*smoke_detectors + 4*rubber_bands, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(23*color_printers + 26*rubber_bands >= 35)
model.addConstr(2*red_pens + 26*rubber_bands >= 18)
model.addConstr(16*paper_clips + 26*rubber_bands >= 27)
model.addConstr(11*yellow_highlighters + 26*rubber_bands >= 34)
model.addConstr(23*color_printers + 16*paper_clips >= 27)
model.addConstr(11*yellow_highlighters + 21*smoke_detectors + 26*rubber_bands >= 47)
model.addConstr(2*red_pens + 23*color_printers + 26*rubber_bands >= 47)
model.addConstr(11*yellow_highlighters + 23*color_printers + 21*smoke_detectors >= 47)
model.addConstr(2*red_pens + 21*smoke_detectors + 26*rubber_bands >= 47)
model.addConstr(11*yellow_highlighters + 16*paper_clips + 21*smoke_detectors >= 47)

# ... (add all other constraints similarly)

model.addConstr(11 * yellow_highlighters + 2 * red_pens + 23 * color_printers + 16 * paper_clips + 21 * smoke_detectors + 26 * rubber_bands <= 296)

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Objective value:", model.objVal)
    print("Variable values:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

