
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize Work Hours")

# Create variables
jean_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean_hours")  # x0
paul_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul_hours")  # x1


# Set objective function
model.setObjective(9 * jean_hours + 9 * paul_hours, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(7 * jean_hours + 5 * paul_hours >= 29, "work_quality_min")
model.addConstr(7 * jean_hours + 5 * paul_hours <= 104, "work_quality_max")
model.addConstr(7 * jean_hours + 8 * paul_hours >= 40, "paperwork_min")
model.addConstr(7 * jean_hours + 8 * paul_hours <= 55, "paperwork_max")
model.addConstr(8 * jean_hours - 6 * paul_hours >= 0, "jean_paul_ratio")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: Jean = {jean_hours.x:.2f} hours, Paul = {paul_hours.x:.2f} hours")
    print(f"Objective value: {model.objVal:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

