
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Jean")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Paul")

# Set the objective function
m.setObjective(9*x0 + 9*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(7*x0 + 5*x1 >= 29, "work_quality_rating_constraint")
m.addConstr(7*x0 + 5*x1 <= 104, "combined_work_quality_upper_bound")
m.addConstr(7*x0 + 8*x1 >= 40, "paperwork_competence_rating_constraint")
m.addConstr(7*x0 + 8*x1 <= 55, "combined_paperwork_competence_upper_bound")
m.addConstr(8*x0 - 6*x1 >= 0, "additional_linear_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Jean: {x0.x}")
    print(f"Hours worked by Paul: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
