
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_Jean', lb=0)  # You can work fractional hours
    x2 = model.addVar(name='hours_worked_by_Paul', lb=0)  # You can work fractional hours

    # Define the objective function
    model.setObjective(9 * x1 + 9 * x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(7 * x1 + 5 * x2 >= 29, name='work_quality_constraint')
    model.addConstr(7 * x1 + 8 * x2 >= 40, name='paperwork_competence_constraint')
    model.addConstr(8 * x1 - 6 * x2 >= 0, name='jean_paul_hours_constraint')
    model.addConstr(7 * x1 + 5 * x2 <= 104, name='max_work_quality_constraint')
    model.addConstr(7 * x1 + 8 * x2 <= 55, name='max_paperwork_competence_constraint')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Hours worked by Jean: {x1.varValue}')
        print(f'Hours worked by Paul: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
