
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="grams_of_fat")
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B7")
    x2 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_magnesium")


    # Set objective function
    m.setObjective(2.27*x0**2 + 5.44*x0*x1 + 4.8*x1**2 + 8.77*x1*x2 + 1.63*x2**2 + 1.53*x2, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1*x0 + 6*x1 + 7*x2 <= 26, "immune_support_index_upper_bound")
    m.addConstr(6*x1 + 7*x2 >= 4, "combined_immune_support_B7_Mg")
    m.addConstr(1*x0 + 6*x1 >= 3, "combined_immune_support_fat_B7")
    m.addConstr(1*x0 + 6*x1 + 7*x2 >= 3, "combined_immune_support_all")
    m.addConstr(3*x0 - 5*x2 >= 0, "constraint_fat_Mg")
    m.addConstr(-2*x1 + 9*x2 >= 0, "constraint_B7_Mg")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('grams of fat:', x0.x)
        print('milligrams of vitamin B7:', x1.x)
        print('milligrams of magnesium:', x2.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
