
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="x1", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="x2", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x3 = model.addVar(name="x3", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    
    # Objective function
    model.setObjective(2.27*x1**2 + 5.44*x1*x2 + 4.8*x2**2 + 8.77*x2*x3 + 1.63*x3**2 + 1.53*x3, gurobi.GRB.MINIMIZE)
    
    # Constraints
    model.addConstr(x1 == 1)
    model.addConstr(6*x2 + 7*x3 >= 4)
    model.addConstr(x1 + 6*x2 >= 3)
    model.addConstr(x1 + 6*x2 + 7*x3 >= 3)
    model.addConstr(3*x1 - 5*x3 >= 0)
    model.addConstr(-2*x2 + 9*x3 >= 0)
    
    # Optimize
    model.optimize()
    
    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"x3: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
