
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    milkshakes = model.addVar(lb=0, name="milkshakes", vtype=gurobi.GRB.CONTINUOUS)
    cheeseburgers = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="cheeseburgers")
    bananas = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="bananas")

    # Define the objective function
    model.setObjective(8 * milkshakes + 4 * cheeseburgers + 4 * bananas, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(milkshakes + 3 * cheeseburgers + bananas >= 16, name="min_spend")
    model.addConstr(11 * milkshakes + 5 * bananas <= 31, name="fiber_milkshakes_bananas")
    model.addConstr(11 * milkshakes + cheeseburgers <= 42, name="fiber_milkshakes_cheeseburgers")
    model.addConstr(cheeseburgers + 5 * bananas <= 27, name="fiber_cheeseburgers_bananas")
    model.addConstr(11 * milkshakes + cheeseburgers + 5 * bananas <= 27, name="fiber_all")
    model.addConstr(milkshakes + 3 * cheeseburgers <= 69, name="max_spend_milkshakes_cheeseburgers")
    model.addConstr(milkshakes + 3 * cheeseburgers + bananas <= 69, name="max_spend_all")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milkshakes: {milkshakes.varValue}")
        print(f"Cheeseburgers: {cheeseburgers.varValue}")
        print(f"Bananas: {bananas.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
