
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Minimize Labor Cost")

    # Create variables
    paul = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Paul")
    bill = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Bill")
    jean = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="Jean")


    # Set objective function
    model.setObjective(6*paul + 4*bill + 3*jean, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(7*paul + 3*jean >= 31, "c0")
    model.addConstr(7*paul + 4*bill >= 20, "c1")
    model.addConstr(7*paul + 4*bill + 3*jean >= 31, "c2")
    model.addConstr(12*paul + 12*jean >= 26, "c3")
    model.addConstr(12*paul + 2*bill >= 31, "c4")
    model.addConstr(12*paul + 2*bill + 12*jean >= 31, "c5")
    model.addConstr(6*paul - bill >= 0, "c6")
    model.addConstr(4*bill - 5*jean >= 0, "c7")
    model.addConstr(7*paul + 4*bill + 3*jean <= 84, "c8")
    model.addConstr(12*paul + 2*bill + 12*jean <= 123, "c9")


    # Optimize model
    model.optimize()

    # Print results
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution found: Objective value = {model.objVal}")
        print(f"Paul's hours: {paul.x}")
        print(f"Bill's hours: {bill.x}")
        print(f"Jean's hours: {jean.x}")
    elif model.status == gp.GRB.INFEASIBLE:
        print("Model is infeasible.")
    else:
        print(f"Optimization terminated with status {model.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
