
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Paul
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Bill
    x2 = model.addVar(name="x2", lb=0, integrality=gurobi.GRB.INTEGER)  # hours worked by Jean

    # Define the objective function
    model.setObjective(6 * x0 + 4 * x1 + 3 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(7 * x0 + 3 * x2 >= 31)
    model.addConstr(7 * x0 + 4 * x1 >= 20)
    model.addConstr(7 * x0 + 4 * x1 + 3 * x2 >= 31)
    model.addConstr(12 * x0 + 12 * x2 >= 26)
    model.addConstr(12 * x0 + 2 * x1 >= 31)
    model.addConstr(12 * x0 + 2 * x1 + 12 * x2 >= 31)
    model.addConstr(6 * x0 - x1 >= 0)
    model.addConstr(4 * x1 - 5 * x2 >= 0)
    model.addConstr(7 * x0 + 4 * x1 + 3 * x2 <= 84)
    model.addConstr(12 * x0 + 2 * x1 + 12 * x2 <= 123)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Hours worked by Paul: ", x0.varValue)
        print("Hours worked by Bill: ", x1.varValue)
        print("Hours worked by Jean: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
