
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    honeypots = m.addVar(vtype=gp.GRB.INTEGER, name="honeypots")
    sys_admins = m.addVar(vtype=gp.GRB.INTEGER, name="system_administrators")
    soc_operators = m.addVar(vtype=gp.GRB.INTEGER, name="SOC_operators")


    # Set objective function
    m.setObjective(4.72 * honeypots + 8.14 * sys_admins + 1.24 * soc_operators, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3.43 * honeypots + 3.96 * sys_admins >= 24, "data_integrity_impact_constraint1")
    m.addConstr(3.43 * honeypots + 3.96 * sys_admins + 5.3 * soc_operators >= 19, "data_integrity_impact_constraint2")
    m.addConstr(3.96 * sys_admins + 5.3 * soc_operators <= 110, "data_integrity_impact_constraint3")
    m.addConstr(3.43 * honeypots + 3.96 * sys_admins + 5.3 * soc_operators <= 110, "data_integrity_impact_constraint4")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('honeypots:', honeypots.x)
        print('system_administrators:', sys_admins.x)
        print('SOC_operators:', soc_operators.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

