
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="honeypots")
x2 = m.addVar(vtype=GRB.INTEGER, name="system_administrators")
x3 = m.addVar(vtype=GRB.INTEGER, name="SOC_operators")

# Set objective function
m.setObjective(4.72*x1 + 8.14*x2 + 1.24*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3.43*x1 + 3.96*x2 >= 24, name="constraint_1")
m.addConstr(3.43*x1 + 3.96*x2 + 5.3*x3 >= 19, name="constraint_2")
m.addConstr(3.96*x2 + 5.3*x3 <= 110, name="constraint_3")
m.addConstr(3.43*x1 + 3.96*x2 + 5.3*x3 <= 113, name="constraint_4")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Honeypots: {x1.x}")
    print(f"System Administrators: {x2.x}")
    print(f"SOC Operators: {x3.x}")
else:
    print("No optimal solution found")
