
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="honeypots", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="system_administrators", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="SOC_operators", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(4.72*x1 + 8.14*x2 + 1.24*x3, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(3.43*x1 <= 113)
m.addConstr(3.96*x2 <= 113)
m.addConstr(5.3*x3 <= 113)
m.addConstr(3.43*x1 + 3.96*x2 >= 24)
m.addConstr(3.43*x1 + 3.96*x2 + 5.3*x3 >= 19)
m.addConstr(3.96*x2 + 5.3*x3 <= 110)
m.addConstr(3.43*x1 + 3.96*x2 + 5.3*x3 <= 110)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Honeypots: {x1.varValue}")
    print(f"System Administrators: {x2.varValue}")
    print(f"SOC Operators: {x3.varValue}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
