
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Minimize Work Hours Cost")

    # Create variables
    laura_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")
    peggy_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy_hours")


    # Set objective function
    model.setObjective(2 * laura_hours + 7 * peggy_hours, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(6 * laura_hours + 12 * peggy_hours >= 73, "work_quality_min")
    model.addConstr(5 * laura_hours + 7 * peggy_hours >= 31, "organization_score_min")
    model.addConstr(-5 * laura_hours + 8 * peggy_hours >= 0, "constraint3")
    model.addConstr(6 * laura_hours + 12 * peggy_hours <= 127, "work_quality_max")
    model.addConstr(5 * laura_hours + 7 * peggy_hours <= 99, "organization_score_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by Laura: {laura_hours.x}")
        print(f"Hours worked by Peggy: {peggy_hours.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
