
from gurobipy import *

# Create a new model
m = Model("Work_Hours_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="hours_worked_by_Laura")
x2 = m.addVar(lb=0, name="hours_worked_by_Peggy")

# Set the objective function
m.setObjective(2*x1 + 7*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(6*x1 + 12*x2 >= 73, "Work_Quality_Rating_Min")
m.addConstr(6*x1 + 12*x2 <= 127, "Work_Quality_Rating_Max")
m.addConstr(5*x1 + 7*x2 >= 31, "Organization_Score_Min")
m.addConstr(5*x1 + 7*x2 <= 99, "Organization_Score_Max")
m.addConstr(-5*x1 + 8*x2 >= 0, "Additional_Linear_Constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Laura: {x1.x}")
    print(f"Hours worked by Peggy: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
