
import gurobi

def solve_optimization_problem():
    try:
        # Create a new model
        m = gurobi.Model()

        # Define variables
        x1 = m.addVar(name="x1", lb=0, ub=None)  # hours worked by Laura
        x2 = m.addVar(name="x2", lb=0, ub=None)  # hours worked by Peggy

        # Objective function
        m.setObjective(2*x1 + 7*x2, gurobi.GRB.MINIMIZE)

        # Constraints
        m.addConstr(6*x1 + 12*x2 >= 73)  
        m.addConstr(5*x1 + 7*x2 >= 31)  
        m.addConstr(-5*x1 + 8*x2 >= 0)  
        m.addConstr(6*x1 + 12*x2 <= 127)  
        m.addConstr(5*x1 + 7*x2 <= 99)  

        # Solve the model
        m.optimize()

        if m.status == gurobi.GRB.Status.OPTIMAL:
            print("Optimal solution found.")
            print(f"Hours worked by Laura: {x1.varValue}")
            print(f"Hours worked by Peggy: {x2.varValue}")
            print(f"Objective: {m.objVal}")
        else:
            print("No optimal solution found.")

    except gurobi.GUROBI_ERROR as e:
        print("Gurobi Error: ", e)

solve_optimization_problem()
