
import gurobipy as gp

# Create a new model
model = gp.Model("Productivity_Optimization")

# Create variables
paul_hours = model.addVar(vtype=gp.GRB.INTEGER, name="paul_hours")
jean_hours = model.addVar(vtype=gp.GRB.INTEGER, name="jean_hours")
ringo_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="ringo_hours")


# Set objective function
model.setObjective(7.29 * paul_hours + 8.85 * jean_hours + 1.49 * ringo_hours, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(7 * paul_hours + 12 * ringo_hours <= 43, "c1")
model.addConstr(9 * jean_hours + 12 * ringo_hours <= 37, "c2")
model.addConstr(7 * paul_hours + 9 * jean_hours + 12 * ringo_hours <= 93, "c3")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Paul's hours: {paul_hours.x}")
    print(f"Jean's hours: {jean_hours.x}")
    print(f"Ringo's hours: {ringo_hours.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

