
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Paul")
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Jean")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Ringo")

# Set the objective function
m.setObjective(7.29*x1 + 8.85*x2 + 1.49*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*x1 + 12*x3 <= 43, name="productivity_constraint_1")
m.addConstr(9*x2 + 12*x3 <= 37, name="productivity_constraint_2")
m.addConstr(7*x1 + 9*x2 + 12*x3 <= 93, name="total_productivity_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Paul: {x1.x}")
    print(f"Hours worked by Jean: {x2.x}")
    print(f"Hours worked by Ringo: {x3.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
