
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_Paul', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='hours_worked_by_Jean', vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name='hours_worked_by_Ringo', vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(7.29 * x1 + 8.85 * x2 + 1.49 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(7 * x1 + 12 * x3 <= 43, name='constraint_1')
    model.addConstr(9 * x2 + 12 * x3 <= 37, name='constraint_2')
    model.addConstr(7 * x1 + 9 * x2 + 12 * x3 <= 93, name='constraint_3')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Hours worked by Paul: ', x1.varValue)
        print('Hours worked by Jean: ', x2.varValue)
        print('Hours worked by Ringo: ', x3.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
