
from gurobipy import *

# Create a new model
m = Model("Optimization_Model")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="deployed_decoys")
x2 = m.addVar(vtype=GRB.INTEGER, name="automatic_alerts")
x3 = m.addVar(vtype=GRB.INTEGER, name="security_onions")
x4 = m.addVar(vtype=GRB.INTEGER, name="pen_testers")
x5 = m.addVar(vtype=GRB.INTEGER, name="patches_per_day")
x6 = m.addVar(vtype=GRB.INTEGER, name="network_administrators")
x7 = m.addVar(vtype=GRB.INTEGER, name="honeypots")

# Objective function (example: minimize the sum)
m.setObjective(x1 + x2 + x3 + x4 + x5 + x6 + x7, GRB.MINIMIZE)

# Constraints (example constraints; replace with actual problem constraints)
m.addConstr(x1 + x2 >= 24, "Example_Constraint_1")
m.addConstr(x3 + x6 <= 692, "Example_Constraint_2")

# Add all other constraints here following the format

# Optimize model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Obj:", m.objVal)
