
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
ringo = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ringo")
hank = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hank")
peggy = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peggy")
laura = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="laura")


# Set objective function
m.setObjective(2.41*ringo**2 + 5.49*ringo*hank + 1.74*ringo*peggy + 6.27*ringo*laura + 9.86*hank**2 + 1.8*hank*laura + 4.41*peggy**2 + 1.09*peggy*laura + 3.96*laura**2 + 8.0*ringo + 9.94*hank + 9.96*peggy + 4.91*laura, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.91*peggy**2 + 0.52*laura**2 >= 42)
m.addConstr(0.32*hank + 0.52*laura >= 64)
m.addConstr(0.71*ringo + 0.32*hank >= 67)
m.addConstr(0.71*ringo + 0.32*hank + 0.91*peggy + 0.52*laura >= 67)
m.addConstr(0.82*hank + 0.66*peggy >= 69)
m.addConstr(0.04*ringo**2 + 0.66*peggy**2 >= 32)
m.addConstr(0.66*peggy + 0.19*laura >= 26)
m.addConstr(0.04*ringo + 0.19*laura >= 40)
m.addConstr(0.04*ringo + 0.82*hank + 0.66*peggy + 0.19*laura >= 40)
m.addConstr(1*ringo - 6*peggy >= 0)
m.addConstr(6*ringo - 10*laura >= 0)
m.addConstr(9*hank**2 - 3*peggy**2 + 10*laura**2 >= 0)
m.addConstr(0.32*hank + 0.91*peggy <= 258)
m.addConstr(0.71*ringo + 0.52*laura <= 321)
m.addConstr(0.32*hank**2 + 0.52*laura**2 <= 243)
m.addConstr(0.32*hank + 0.91*peggy + 0.52*laura <= 154)
m.addConstr(0.04*ringo**2 + 0.19*laura**2 <= 163)
m.addConstr(0.66*peggy**2 + 0.19*laura**2 <= 186)
m.addConstr(0.82*hank + 0.19*laura <= 143)
m.addConstr(0.04*ringo**2 + 0.82*hank**2 + 0.66*peggy**2 <= 245)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

