
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="x0", lb=0)  # hours worked by Ringo
x1 = model.addVar(name="x1", lb=0)  # hours worked by Hank
x2 = model.addVar(name="x2", lb=0)  # hours worked by Peggy
x3 = model.addVar(name="x3", lb=0)  # hours worked by Laura

# Define the objective function
model.setObjective(2.41*x0**2 + 5.49*x0*x1 + 1.74*x0*x2 + 6.27*x0*x3 + 
                   9.86*x1**2 + 1.8*x1*x3 + 4.41*x2**2 + 1.09*x2*x3 + 
                   3.96*x3**2 + 8.0*x0 + 9.94*x1 + 9.96*x2 + 4.91*x3, 
                   gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(0.71*x0 <= 391)
model.addConstr(0.04*x0 <= 305)
model.addConstr(0.32*x1 <= 391)
model.addConstr(0.82*x1 <= 305)
model.addConstr(0.91*x2 <= 391)
model.addConstr(0.66*x2 <= 305)
model.addConstr(0.52*x3 <= 391)
model.addConstr(0.19*x3 <= 305)
model.addConstr(0.91*x2**2 + 0.52*x3**2 >= 42)
model.addConstr(0.32*x1 + 0.52*x3 >= 64)
model.addConstr(0.71*x0 + 0.32*x1 >= 67)
model.addConstr(0.71*x0 + 0.32*x1 + 0.91*x2 + 0.52*x3 >= 67)
model.addConstr(0.82*x1 + 0.66*x2 >= 69)
model.addConstr(0.04*x0**2 + 0.66*x2**2 >= 32)
model.addConstr(0.66*x2 + 0.19*x3 >= 26)
model.addConstr(0.04*x0 + 0.19*x3 >= 40)
model.addConstr(0.04*x0 + 0.82*x1 + 0.66*x2 + 0.19*x3 >= 40)
model.addConstr(x0 - 6*x2 >= 0)
model.addConstr(6*x0 - 10*x3 >= 0)
model.addConstr(9*x1**2 - 3*x2**2 + 10*x3**2 >= 0)
model.addConstr(0.32*x1 + 0.91*x2 <= 258)
model.addConstr(0.71*x0 + 0.52*x3 <= 321)
model.addConstr(0.32*x1**2 + 0.52*x3**2 <= 243)
model.addConstr(0.32*x1 + 0.91*x2 + 0.52*x3 <= 154)
model.addConstr(0.04*x0**2 + 0.19*x3**2 <= 163)
model.addConstr(0.66*x2**2 + 0.19*x3**2 <= 186)
model.addConstr(0.82*x1 + 0.19*x3 <= 143)
model.addConstr(0.04*x0**2 + 0.82*x1**2 + 0.66*x2**2 <= 245)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
