
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="bowls_of_cereal")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="oranges")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="bowls_of_pasta")

# Define the objective function
m.setObjective(8*x0 + 3*x1 + 2*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(6*x0 + 5*x2 >= 21, "carb_cereal_pasta")
m.addConstr(6*x0 + 3*x1 + 5*x2 >= 34, "total_carb_all")
m.addConstr(4*x0 + x2 >= 37, "calcium_cereal_pasta")
m.addConstr(4*x0 + 4*x1 >= 23, "calcium_cereal_oranges")
m.addConstr(4*x1 + x2 >= 34, "calcium_oranges_pasta")
m.addConstr(4*x0 + 4*x1 + x2 >= 35, "total_calcium_all")
m.addConstr(6*x0 + 5*x2 <= 48, "carb_limit_cereal_pasta")
m.addConstr(6*x0 + 3*x1 + 5*x2 <= 73, "total_carb_limit_all")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
else:
    print('No optimal solution found')
