
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="bowls_of_cereal", lb=0)
    x1 = model.addVar(name="oranges", lb=0)
    x2 = model.addVar(name="bowls_of_pasta", lb=0)

    # Define the objective function
    model.setObjective(8 * x0 + 3 * x1 + 2 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(6 * x0 + 3 * x1 + 5 * x2 >= 34, name="carbohydrates_total")
    model.addConstr(4 * x0 + 4 * x1 >= 23, name="calcium_cereal_orange")
    model.addConstr(4 * x0 + x2 >= 37, name="calcium_cereal_pasta")
    model.addConstr(4 * x1 + x2 >= 34, name="calcium_orange_pasta")
    model.addConstr(4 * x0 + 4 * x1 + x2 >= 35, name="calcium_all")
    model.addConstr(6 * x0 + 5 * x2 <= 48, name="carbohydrates_cereal_pasta")
    model.addConstr(6 * x0 + 3 * x1 + 5 * x2 <= 73, name="carbohydrates_all")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"bowls of cereal: {x0.varValue}")
        print(f"oranges: {x1.varValue}")
        print(f"bowls of pasta: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
