
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
eggs = m.addVar(vtype=gp.GRB.INTEGER, name="eggs")
bacon = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bacon")
sandwiches = m.addVar(vtype=gp.GRB.INTEGER, name="sandwiches")
chicken = m.addVar(vtype=gp.GRB.INTEGER, name="chicken")

# Set objective function
m.setObjective(6*eggs + 3*bacon + 6*sandwiches + 9*chicken, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8*eggs + 17*bacon >= 31)
m.addConstr(8*eggs + 14*chicken >= 36)
m.addConstr(17*bacon + 8*sandwiches >= 18)
m.addConstr(17*bacon + 8*sandwiches + 14*chicken >= 35)
m.addConstr(8*eggs + 8*sandwiches + 14*chicken >= 35)
m.addConstr(8*eggs + 17*bacon + 14*chicken >= 35)
m.addConstr(17*bacon + 8*sandwiches + 14*chicken >= 38)
m.addConstr(8*eggs + 8*sandwiches + 14*chicken >= 38)
m.addConstr(8*eggs + 17*bacon + 14*chicken >= 38)
m.addConstr(17*bacon + 8*sandwiches + 14*chicken >= 36)
m.addConstr(8*eggs + 8*sandwiches + 14*chicken >= 36)
m.addConstr(8*eggs + 17*bacon + 14*chicken >= 36)
m.addConstr(8*eggs + 17*bacon + 8*sandwiches + 14*chicken >= 36)
m.addConstr(3*bacon + 6*chicken >= 15)
m.addConstr(7*eggs + 10*sandwiches >= 45)
m.addConstr(10*sandwiches + 6*chicken >= 32)
m.addConstr(7*eggs + 3*bacon + 6*chicken >= 22)
m.addConstr(7*eggs + 3*bacon + 10*sandwiches + 6*chicken >= 22)
m.addConstr(13*sandwiches + 8*chicken >= 21)
m.addConstr(8*eggs + 6*bacon >= 15)
m.addConstr(8*eggs + 8*chicken >= 18)
m.addConstr(6*bacon + 13*sandwiches >= 11)
m.addConstr(8*eggs + 6*bacon + 13*sandwiches + 8*chicken >= 11)
m.addConstr(9*bacon - sandwiches >= 0)
m.addConstr(8*sandwiches + 14*chicken <= 60)
m.addConstr(10*sandwiches + 6*chicken <= 151)

# Resource Constraints
m.addConstr(8*eggs <= 167)
m.addConstr(7*eggs <= 183)
m.addConstr(8*eggs <= 118)
m.addConstr(17*bacon <= 167)
m.addConstr(3*bacon <= 183)
m.addConstr(6*bacon <= 118)
m.addConstr(8*sandwiches <= 167)
m.addConstr(10*sandwiches <= 183)
m.addConstr(13*sandwiches <= 118)
m.addConstr(14*chicken <= 167)
m.addConstr(6*chicken <= 183)
m.addConstr(8*chicken <= 118)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

