
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="eggs", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="strips of bacon", vtype=gp.GRB.CONTINUOUS)
x2 = m.addVar(name="peanutbutter sandwiches", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="chicken breasts", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(6*x0 + 3*x1 + 6*x2 + 9*x3, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(8*x0 + 17*x1 >= 31)
m.addConstr(8*x0 + 14*x3 >= 36)
m.addConstr(17*x1 + 8*x2 >= 18)
m.addConstr(17*x1 + 8*x2 + 14*x3 >= 35)
m.addConstr(8*x0 + 8*x2 + 14*x3 >= 35)
m.addConstr(8*x0 + 17*x1 + 14*x3 >= 35)
m.addConstr(17*x1 + 8*x2 + 14*x3 >= 38)
m.addConstr(8*x0 + 8*x2 + 14*x3 >= 38)
m.addConstr(8*x0 + 17*x1 + 14*x3 >= 38)
m.addConstr(17*x1 + 8*x2 + 14*x3 >= 36)
m.addConstr(8*x0 + 8*x2 + 14*x3 >= 36)
m.addConstr(8*x0 + 17*x1 + 14*x3 >= 36)
m.addConstr(8*x0 + 17*x1 + 8*x2 + 14*x3 >= 36)
m.addConstr(3*x1 + 6*x3 >= 15)
m.addConstr(7*x0 + 10*x2 >= 45)
m.addConstr(10*x2 + 6*x3 >= 32)
m.addConstr(7*x0 + 3*x1 + 6*x3 >= 22)
m.addConstr(7*x0 + 3*x1 + 10*x2 + 6*x3 >= 22)
m.addConstr(13*x2 + 8*x3 >= 21)
m.addConstr(8*x0 + 6*x1 >= 15)
m.addConstr(8*x0 + 8*x3 >= 18)
m.addConstr(6*x1 + 13*x2 >= 11)
m.addConstr(8*x0 + 6*x1 + 13*x2 + 8*x3 >= 11)
m.addConstr(9*x1 - x2 >= 0)
m.addConstr(8*x2 + 14*x3 <= 60)
m.addConstr(10*x2 + 6*x3 <= 151)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Eggs: ", x0.varValue)
    print("Strips of bacon: ", x1.varValue)
    print("Peanutbutter sandwiches: ", x2.varValue)
    print("Chicken breasts: ", x3.varValue)
else:
    print("The model is infeasible")
