
import gurobi

def optimize():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="slices of pizza", lb=0)
    x1 = model.addVar(name="knishes", lb=0)
    x2 = model.addVar(name="bagged salads", lb=0)
    x3 = model.addVar(name="corn cobs", lb=0)
    x4 = model.addVar(name="steaks", lb=0)
    x5 = model.addVar(name="tomatoes", lb=0)
    x6 = model.addVar(name="hot dogs", lb=0)

    # Objective function
    model.setObjective(2.85*x0 + 8.81*x1 + 5.07*x2 + 8.27*x3 + 1.99*x4 + 9.22*x5 + 4.38*x6, gurobi.GRB_MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x5 >= 20)
    model.addConstr(x1 + x2 >= 24)
    model.addConstr(x3 + x5 >= 59)
    model.addConstr(x2 + x3 >= 47)
    model.addConstr(x4 + x6 >= 50)
    model.addConstr(x2 + x4 + x6 >= 42)
    model.addConstr(x0 + x4 + x5 >= 42)
    model.addConstr(x1 + x5 + x6 >= 42)
    model.addConstr(x1 + x4 + x6 >= 42)
    model.addConstr(x1 + x2 + x5 >= 42)
    model.addConstr(x0 + x2 + x6 >= 42)
    model.addConstr(x3 + x4 + x5 >= 42)
    model.addConstr(x0 + x1 + x2 >= 42)
    model.addConstr(x1 + x3 + x5 >= 42)
    model.addConstr(x2 + x3 + x6 >= 42)
    model.addConstr(x2 + x3 + x5 >= 42)
    model.addConstr(x2 + x4 + x5 >= 42)
    model.addConstr(x2 + x4 + x6 >= 58)
    model.addConstr(x0 + x4 + x5 >= 58)
    model.addConstr(x1 + x5 + x6 >= 58)
    model.addConstr(x1 + x4 + x6 >= 58)
    model.addConstr(x1 + x2 + x5 >= 58)
    model.addConstr(x0 + x2 + x6 >= 58)
    model.addConstr(x3 + x4 + x5 >= 58)
    model.addConstr(x0 + x1 + x2 >= 58)
    model.addConstr(x1 + x3 + x5 >= 58)
    model.addConstr(x2 + x3 + x6 >= 58)
    model.addConstr(x2 + x3 + x5 >= 58)
    model.addConstr(x2 + x4 + x5 >= 58)
    model.addConstr(11*x0 + 4*x1 + 5*x2 + 4*x3 + 8*x4 + 13*x5 + 7*x6 <= 446)
    model.addConstr(12*x0 + 1*x1 + 6*x2 + 8*x3 + 4*x4 + 6*x5 + 8*x6 <= 439)
    model.addConstr(x0 * 12 + x3 * 8 <= 408)
    model.addConstr(x3 * 8 + x5 * 6 <= 345)
    model.addConstr(x2 * 6 + x6 * 8 <= 88)
    model.addConstr(x2 * 6 + x4 * 4 + x6 * 8 <= 114)
    model.addConstr(x0 * 12 + x5 * 6 + x6 * 8 <= 327)
    model.addConstr(x0 * 12 + x1 * 1 + x3 * 8 <= 181)
    model.addConstr(x1 * 1 + x3 * 8 + x4 * 4 <= 269)
    model.addConstr(x3 * 8 + x4 * 4 + x6 * 8 <= 343)
    model.addConstr(x3 * 8 + x4 * 4 + x5 * 6 <= 101)
    model.addConstr(x2 * 6 + x4 * 4 + x5 * 6 <= 430)
    model.addConstr(x0 * 12 + x1 * 1 + x2 * 6 <= 382)
    model.addConstr(x1 * 1 + x2 * 6 + x3 * 8 <= 139)
    model.addConstr(x0 + x1 + x2 + x3 + x4 + x5 + x6 <= 139)
    model.addConstr(4*x1 + 13*x5 + 7*x6 <= 300)
    model.addConstr(11*x0 + 13*x5 <= 313)
    model.addConstr(11*x0 + 4*x3 <= 190)
    model.addConstr(4*x3 + 7*x6 <= 227)
    model.addConstr(11*x0 + 4*x1 <= 315)
    model.addConstr(4*x3 + 13*x5 <= 218)
    model.addConstr(4*x4 + 7*x6 <= 90)
    model.addConstr(4*x3 + 4*x4 + 13*x5 <= 135)
    model.addConstr(11*x0 + 5*x2 + 4*x3 <= 425)
    model.addConstr(4*x4 + 13*x5 + 7*x6 <= 203)
    model.addConstr(4*x1 + 5*x2 + 4*x4 <= 303)
    model.addConstr(4*x3 + 4*x4 + 7*x6 <= 385)
    model.addConstr(11*x0 + 4*x1 + 5*x2 <= 242)
    model.addConstr(11*x0 + 13*x5 + 7*x6 <= 149)
    model.addConstr(4*x1 + 4*x3 + 13*x5 <= 215)
    model.addConstr(11*x0 + 5*x2 + 7*x6 <= 85)
    model.addConstr(4*x1 + 5*x2 + 7*x6 <= 352)
    model.addConstr(11*x0 + 4*x4 <= 94)
    model.addConstr(11*x0 + 4*x4 + 13*x5 <= 134)
    model.addConstr(4*x1 + 5*x2 + 13*x5 <= 236)
    model.addConstr(11*x0 + 4*x1 + 5*x2 + 4*x3 + 4*x4 + 13*x5 + 7*x6 <= 236)

    model.optimize()

    if model.status == gurobi.GRB_OPTIMAL:
        print("Objective: ", model.objVal)
        print("slices of pizza: ", x0.varValue)
        print("knishes: ", x1.varValue)
        print("bagged salads: ", x2.varValue)
        print("corn cobs: ", x3.varValue)
        print("steaks: ", x4.varValue)
        print("tomatoes: ", x5.varValue)
        print("hot dogs: ", x6.varValue)
    else:
        print("No solution found")

optimize()
