
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Hours_Optimization")

# Create variables
hank = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
jean = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")
bill = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")
laura = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura")
peggy = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")
ringo = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")
mary = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary")
bobby = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby")


# Set objective function
model.setObjective(9*hank + 6*jean + 6*bill + 4*laura + 9*peggy + 7*ringo + 9*mary + 1*bobby, gp.GRB.MAXIMIZE)

# Add constraints

productivity_rating = {'hank': 12, 'jean': 4, 'bill': 7, 'laura': 2, 'peggy': 12, 'ringo': 3, 'mary': 6, 'bobby': 1}
organization_score = {'hank': 1, 'jean': 10, 'bill': 4, 'laura': 5, 'peggy': 9, 'ringo': 10, 'mary': 12, 'bobby': 8}

model.addConstr(productivity_rating['bill'] * bill + productivity_rating['laura'] * laura >= 7)
model.addConstr(productivity_rating['bill'] * bill + productivity_rating['ringo'] * ringo >= 4)
model.addConstr(productivity_rating['laura'] * laura + productivity_rating['ringo'] * ringo >= 11)
model.addConstr(productivity_rating['hank'] * hank + productivity_rating['jean'] * jean >= 11)
# ... (add all other constraints similarly using the dictionaries)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Model status:", model.status)

