
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x = model.addVars(8, name="x", lb=0)

    # Objective function
    model.setObjective(9*x[0] + 6*x[1] + 6*x[2] + 4*x[3] + 9*x[4] + 7*x[5] + 9*x[6] + x[7], gurobi.GRB.MAXIMIZE)

    # Productivity rating constraints
    model.addConstr(12*x[0] <= 114)
    model.addConstr(4*x[1] <= 114)
    model.addConstr(7*x[2] <= 114)
    model.addConstr(2*x[3] <= 114)
    model.addConstr(12*x[4] <= 114)
    model.addConstr(3*x[5] <= 114)
    model.addConstr(6*x[6] <= 114)
    model.addConstr(x[7] <= 114)

    # Organization score constraints (illustrative)
    model.addConstr(x[0] + 1*x[1] + 0*x[2] + 0*x[3] + 0*x[4] + 0*x[5] + 0*x[6] + 0*x[7] <= 147)

    # Detailed constraints (illustrative)
    model.addConstr(7*x[2] + 2*x[3] >= 7)
    model.addConstr(7*x[2] + 3*x[5] >= 4)
    model.addConstr(2*x[3] + 3*x[5] >= 11)
    model.addConstr(12*x[0] + 4*x[1] >= 11)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        for i in range(8):
            print(f"x[{i}] = {x[i].x}")
    else:
        print("No solution found")

solve_optimization_problem()
