
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize Labor Cost")

# Create variables
laura_hours = model.addVar(vtype=gp.GRB.INTEGER, name="laura_hours")
bobby_hours = model.addVar(vtype=gp.GRB.INTEGER, name="bobby_hours")
dale_hours = model.addVar(vtype=gp.GRB.INTEGER, name="dale_hours")
george_hours = model.addVar(vtype=gp.GRB.INTEGER, name="george_hours")


# Set objective function
model.setObjective(4 * laura_hours + 3 * bobby_hours + 7 * dale_hours + 5 * george_hours, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(2 * bobby_hours + 3 * george_hours >= 9, "c1")
model.addConstr(5 * dale_hours + 3 * george_hours >= 13, "c2")
model.addConstr(6 * laura_hours + 2 * bobby_hours + 5 * dale_hours + 3 * george_hours >= 13, "c3")
model.addConstr(10 * dale_hours - 2 * george_hours >= 0, "c4")
model.addConstr(4 * laura_hours - dale_hours >= 0, "c5")
model.addConstr(6 * laura_hours + 2 * bobby_hours + 5 * dale_hours <= 44, "c6")



# Optimize model
model.optimize()

# Check for infeasibility
if model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal Solution:")
    print(f"Laura's hours: {laura_hours.x}")
    print(f"Bobby's hours: {bobby_hours.x}")
    print(f"Dale's hours: {dale_hours.x}")
    print(f"George's hours: {george_hours.x}")
    print(f"Objective Value: {model.objVal}")

