
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_Laura', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='hours_worked_by_Bobby', vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name='hours_worked_by_Dale', vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name='hours_worked_by_George', vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(4*x1 + 3*x2 + 7*x3 + 5*x4, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2*x2 + 3*x4 >= 9)
    model.addConstr(5*x3 + 3*x4 >= 13)
    model.addConstr(6*x1 + 2*x2 + 5*x3 + 3*x4 >= 13)
    model.addConstr(10*x3 - 2*x4 >= 0)
    model.addConstr(4*x1 - x3 >= 0)
    model.addConstr(6*x1 + 2*x2 + 5*x3 <= 44)

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('Hours worked by Laura: ', x1.varValue)
        print('Hours worked by Bobby: ', x2.varValue)
        print('Hours worked by Dale: ', x3.varValue)
        print('Hours worked by George: ', x4.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
