
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0") # milligrams of vitamin B12 (integer)
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of iron (continuous)
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="x2") # milligrams of zinc (integer)


    # Set objective function
    m.setObjective(4.94 * x0 + 9.67 * x1 + 2.41 * x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(5.39 * x0 + 7.24 * x2 >= 9)
    m.addConstr(5.39 * x0 + 3.4 * x1 >= 13)
    m.addConstr(5.39 * x0 + 3.4 * x1 + 7.24 * x2 >= 13)
    m.addConstr(8.08 * x0 + 5.23 * x1 >= 29)
    m.addConstr(8.08 * x0 + 5.23 * x1 + 8.59 * x2 >= 29)
    m.addConstr(10.29 * x0 + 13.7 * x2 >= 20)
    m.addConstr(10.29 * x0 + 5.27 * x1 >= 49)
    m.addConstr(10.29 * x0 + 5.27 * x1 + 13.7 * x2 >= 49)
    m.addConstr(6 * x0 - 5 * x1 >= 0)
    m.addConstr(-3 * x0 + 3 * x2 >= 0)
    m.addConstr(5.39 * x0 + 3.4 * x1 <= 34)
    m.addConstr(3.4 * x1 + 7.24 * x2 <= 65)
    m.addConstr(8.08 * x0 + 5.23 * x1 <= 194)
    m.addConstr(8.08 * x0 + 5.23 * x1 + 8.59 * x2 <= 194)
    m.addConstr(10.29 * x0 + 5.27 * x1 + 13.7 * x2 <= 116)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
        print('x2: %g' % x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
