
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin B12
    x2 = model.addVar(name="x2")  # milligrams of iron
    x3 = model.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # milligrams of zinc

    # Objective function
    model.setObjective(4.94 * x1 + 9.67 * x2 + 2.41 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5.39 * x1 + 3.4 * x2 + 7.24 * x3 >= 9)
    model.addConstr(5.39 * x1 + 3.4 * x2 >= 13)
    model.addConstr(8.08 * x1 + 5.23 * x2 >= 29)
    model.addConstr(8.08 * x1 + 5.23 * x2 + 8.59 * x3 >= 29)
    model.addConstr(10.29 * x1 + 13.7 * x3 >= 20)
    model.addConstr(10.29 * x1 + 5.27 * x2 >= 49)
    model.addConstr(10.29 * x1 + 5.27 * x2 + 13.7 * x3 >= 49)
    model.addConstr(6 * x1 - 5 * x2 >= 0)
    model.addConstr(-3 * x1 + 3 * x3 >= 0)
    model.addConstr(5.39 * x1 + 3.4 * x2 <= 34)
    model.addConstr(3.4 * x2 + 7.24 * x3 <= 65)
    model.addConstr(8.08 * x1 + 5.23 * x2 <= 194)
    model.addConstr(8.08 * x1 + 5.23 * x2 + 8.59 * x3 <= 194)
    model.addConstr(10.29 * x1 + 5.27 * x2 + 13.7 * x3 <= 116)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x1 (milligrams of vitamin B12): {x1.varValue}")
        print(f"x2 (milligrams of iron): {x2.varValue}")
        print(f"x3 (milligrams of zinc): {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
