
import gurobi

# Define variables
model = gurobi.Model()
x0 = model.addVar(name="hot_dogs", vtype=gurobi.GRB.INTEGER)
x1 = model.addVar(name="kiwis", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name="sashimi", vtype=gurobi.GRB.INTEGER)
x3 = model.addVar(name="chicken_thighs", vtype=gurobi.GRB.INTEGER)
x4 = model.addVar(name="bananas", vtype=gurobi.GRB.INTEGER)

# Objective function
model.setObjective(4*x0 + 2*x1 + 6*x2 + 8*x3 + 2*x4, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(9*x0 + 13*x1 >= 52)
model.addConstr(9*x0 + 8*x2 >= 55)
model.addConstr(13*x1 + 8*x2 + 7*x4 >= 36)
model.addConstr(9*x0 + 8*x2 + 5*x3 >= 36)
model.addConstr(13*x1 + 8*x2 + 5*x3 >= 36)
model.addConstr(9*x0 + 13*x1 + 7*x4 >= 36)
model.addConstr(9*x0 + 13*x1 + 5*x3 >= 36)
model.addConstr(9*x0 + 5*x3 + 7*x4 >= 36)
model.addConstr(9*x0 + 8*x2 + 7*x4 >= 36)
model.addConstr(13*x1 + 8*x2 + 7*x4 >= 40)
model.addConstr(9*x0 + 8*x2 + 5*x3 >= 40)
model.addConstr(13*x1 + 8*x2 + 5*x3 >= 40)
model.addConstr(15*x0 + 17*x2 + 9*x4 >= 33)
model.addConstr(16*x1 + 9*x4 <= 207)
model.addConstr(7*x3 + 9*x4 <= 217)
model.addConstr(15*x0 + 16*x1 + 17*x2 + 7*x3 + 9*x4 <= 217)
model.addConstr(13*x1 + 5*x3 <= 241)
model.addConstr(8*x2 + 5*x3 <= 118)
model.addConstr(5*x3 + 7*x4 <= 100)
model.addConstr(9*x0 + 5*x3 <= 73)
model.addConstr(13*x1 + 7*x4 <= 156)
model.addConstr(13*x1 + 8*x2 <= 209)
model.addConstr(9*x0 + 13*x1 <= 98)
model.addConstr(9*x0 + 8*x2 <= 131)
model.addConstr(13*x1 + 8*x2 + 5*x3 <= 112)
model.addConstr(9*x0 + 8*x2 + 5*x3 <= 221)
model.addConstr(13*x1 + 5*x3 + 7*x4 <= 235)
model.addConstr(9*x0 + 13*x1 + 7*x4 <= 261)
model.addConstr(9*x0 + 13*x1 + 8*x2 <= 157)
model.addConstr(13*x1 + 8*x2 + 7*x4 <= 178)
model.addConstr(9*x0 + 8*x2 + 7*x4 <= 73)
model.addConstr(9*x0 + 13*x1 + 8*x2 + 5*x3 + 7*x4 <= 73)

# Optimize
model.optimize()

# Print solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Hot dogs: ", x0.varValue)
    print("Kiwis: ", x1.varValue)
    print("Sashimi: ", x2.varValue)
    print("Chicken thighs: ", x3.varValue)
    print("Bananas: ", x4.varValue)
else:
    print("No solution found")
