
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("minimize_cost")

# Create variables
bobby = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bobby")
jean = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="jean")
hank = m.addVar(lb=0, vtype=GRB.INTEGER, name="hank")
george = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="george")


# Set objective function
m.setObjective(9 * bobby + 8 * jean + 2 * hank + 6 * george, GRB.MINIMIZE)

# Add constraints
m.addConstr(15 * jean + 17 * george >= 40, "c1")
m.addConstr(3 * bobby + 15 * jean + 17 * george >= 38, "c2")
m.addConstr(3 * bobby + 15 * jean + 12 * hank + 17 * george >= 38, "c3")
m.addConstr(-3 * hank + 10 * george >= 0, "c4")
m.addConstr(3 * bobby + 17 * george <= 113, "c5")
m.addConstr(3 * bobby + 12 * hank + 17 * george <= 52, "c6")



# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

