
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Bobby
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Jean
    x3 = model.addVar(name="x3", lb=0, integrality=1)  # hours worked by Hank
    x4 = model.addVar(name="x4", lb=0)  # hours worked by George

    # Define the objective function
    model.setObjective(9 * x1 + 8 * x2 + 2 * x3 + 6 * x4, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(15 * x2 + 17 * x4 >= 40)
    model.addConstr(3 * x1 + 15 * x2 + 17 * x4 >= 38)
    model.addConstr(3 * x1 + 15 * x2 + 12 * x3 + 17 * x4 >= 38)
    model.addConstr(-3 * x3 + 10 * x4 >= 0)
    model.addConstr(3 * x1 + 17 * x4 <= 113)
    model.addConstr(3 * x1 + 12 * x3 + 17 * x4 <= 52)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Bobby: {x1.varValue}")
        print(f"Hours worked by Jean: {x2.varValue}")
        print(f"Hours worked by Hank: {x3.varValue}")
        print(f"Hours worked by George: {x4.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
