
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.CONTINUOUS, name="rotisserie_chickens")
    x1 = m.addVar(vtype=GRB.INTEGER, name="eggs")
    x2 = m.addVar(vtype=GRB.CONTINUOUS, name="granola_bars")


    # Set objective function
    m.setObjective(3*x0**2 + 2*x0*x1 + 7*x0*x2 + x1**2 + 2*x1*x2 + x2**2 + x0 + 9*x1 + 7*x2, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(10*x0**2 + 11*x2**2 >= 69, "c0")
    m.addConstr(3*x1 + 11*x2 >= 65, "c1")
    m.addConstr(8*x0 + 9*x2 >= 16, "c2")
    m.addConstr(3*x1 + 11*x2 <= 184, "c3")
    m.addConstr(10*x0 + 3*x1 <= 209, "c4")
    m.addConstr(10*x0 + 3*x1 + 11*x2 <= 209, "c5")
    m.addConstr(8*x0**2 + 9*x2**2 <= 87, "c6")
    m.addConstr(9*x1**2 + 9*x2**2 <= 82, "c7")
    m.addConstr(8*x0 + 9*x1 + 9*x2 <= 82, "c8")
    m.addConstr(10*x0 + 3*x1 + 11*x2 <= 221, "r0")
    m.addConstr(8*x0 + 9*x1 + 9*x2 <= 127, "r1")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
