
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=-gurobi.GRB.INFINITY)  # rotisserie chickens
x1 = m.addVar(name="x1", lb=0, type=gurobi.GRB.INTEGER)  # eggs
x2 = m.addVar(name="x2", lb=-gurobi.GRB.INFINITY)  # granola bars

# Objective function
m.setObjective(3*x0**2 + 2*x0*x1 + 7*x0*x2 + x1**2 + 2*x1*x2 + x2**2 + x0 + 9*x1 + 7*x2, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(10*x0 <= 221)
m.addConstr(8*x0 <= 127)
m.addConstr(3*x1 <= 221)
m.addConstr(9*x1 <= 127)
m.addConstr(11*x2 <= 221)
m.addConstr(9*x2 <= 127)
m.addConstr(10*x0**2 + 11*x2**2 >= 69)
m.addConstr(3*x1 + 11*x2 >= 65)
m.addConstr(8*x0 + 9*x2 >= 16)
m.addConstr(3*x1 + 11*x2 <= 184)
m.addConstr(10*x0 + 3*x1 <= 209)
m.addConstr(10*x0 + 3*x1 + 11*x2 <= 209)
m.addConstr(8*x0**2 + 9*x2**2 <= 87)
m.addConstr(9*x1**2 + 9*x2**2 <= 82)
m.addConstr(8*x0 + 9*x1 + 9*x2 <= 82)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.x)
    print("x1: ", x1.x)
    print("x2: ", x2.x)
else:
    print("The model is infeasible")
