
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
vincas = m.addVar(vtype=gp.GRB.INTEGER, name="vincas")
roses = m.addVar(vtype=gp.GRB.INTEGER, name="roses")
bean_stalks = m.addVar(vtype=gp.GRB.INTEGER, name="bean_stalks")
chives = m.addVar(vtype=gp.GRB.INTEGER, name="chives")

# Set objective function
m.setObjective(3 * vincas + 1 * roses + 7 * bean_stalks + 7 * chives, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * vincas + 10 * bean_stalks >= 33)
m.addConstr(10 * roses + 9 * chives >= 33)
m.addConstr(3 * vincas + 10 * roses + 10 * bean_stalks + 9 * chives >= 33)
m.addConstr(10 * roses + 11 * bean_stalks >= 22)
m.addConstr(11 * bean_stalks + 7 * chives >= 26)
m.addConstr(10 * vincas + 10 * roses >= 20)
m.addConstr(10 * vincas + 11 * bean_stalks >= 15)
m.addConstr(10 * vincas + 10 * roses + 11 * bean_stalks >= 25)
m.addConstr(10 * roses + 11 * bean_stalks + 7 * chives >= 25)
m.addConstr(10 * vincas + 10 * roses + 7 * chives >= 25)
m.addConstr(10 * vincas + 10 * roses + 11 * bean_stalks >= 30)
m.addConstr(10 * roses + 11 * bean_stalks + 7 * chives >= 30)
m.addConstr(10 * vincas + 10 * roses + 7 * chives >= 30)
m.addConstr(10 * vincas + 10 * roses + 11 * bean_stalks >= 41)
m.addConstr(10 * roses + 11 * bean_stalks + 7 * chives >= 41)
m.addConstr(10 * vincas + 10 * roses + 7 * chives >= 41)
m.addConstr(10 * vincas + 10 * roses + 11 * bean_stalks + 7 * chives >= 41)
m.addConstr(10 * roses + 10 * bean_stalks <= 159)
m.addConstr(3 * vincas + 10 * roses <= 138)
m.addConstr(10 * vincas + 10 * roses + 11 * bean_stalks <= 75)
m.addConstr(10 * vincas + 10 * roses + 7 * chives <= 93)
m.addConstr(3*vincas + 10*roses + 10*bean_stalks + 9*chives <= 183)
m.addConstr(10*vincas + 10*roses + 11*bean_stalks + 7*chives <= 172)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vincas:', vincas.x)
    print('roses:', roses.x)
    print('bean_stalks:', bean_stalks.x)
    print('chives:', chives.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

