
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="vincas", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="roses", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="bean_stalks", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="chives", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(3*x0 + x1 + 7*x2 + 7*x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(3*x0 >= 33, name="min_vincas")
m.addConstr(10*x1 + 9*x3 >= 33, name="min_roses_chives")
m.addConstr(3*x0 + 10*x1 + 10*x2 + 9*x3 >= 33, name="total_min_spend")
m.addConstr(10*x1 + 11*x2 >= 22, name="min_resilience_roses_bean_stalks")
m.addConstr(11*x2 + 7*x3 >= 26, name="min_resilience_bean_stalks_chives")
m.addConstr(10*x0 + 10*x1 >= 20, name="min_resilience_vincas_roses")
m.addConstr(10*x0 + 11*x2 >= 15, name="min_resilience_vincas_bean_stalks")
m.addConstr(10*x0 + 10*x1 + 11*x2 >= 25, name="min_resilience_vincas_roses_bean_stalks")
m.addConstr(10*x1 + 11*x2 + 7*x3 >= 25, name="min_resilience_roses_bean_stalks_chives")
m.addConstr(10*x0 + 10*x1 + 7*x3 >= 25, name="min_resilience_vincas_roses_chives")
m.addConstr(10*x0 + 10*x1 + 11*x2 >= 30, name="resilience_vincas_roses_bean_stalks")
m.addConstr(10*x1 + 11*x2 + 7*x3 >= 30, name="resilience_roses_bean_stalks_chives")
m.addConstr(10*x0 + 10*x1 + 7*x3 >= 30, name="resilience_vincas_roses_chives")
m.addConstr(10*x0 + 10*x1 + 11*x2 >= 41, name="resilience_vincas_roses_bean_stalks_min")
m.addConstr(10*x1 + 11*x2 + 7*x3 >= 41, name="resilience_roses_bean_stalks_chives_min")
m.addConstr(10*x0 + 10*x1 + 7*x3 >= 41, name="resilience_vincas_roses_chives_min")
m.addConstr(10*x0 + 10*x1 + 11*x2 + 7*x3 >= 41, name="total_resilience_min")
m.addConstr(10*x1 + 10*x2 <= 159, name="max_spend_roses_bean_stalks")
m.addConstr(3*x0 + 10*x1 <= 138, name="max_spend_vincas_roses")
m.addConstr(10*x0 + 10*x1 + 11*x2 <= 75, name="max_resilience_vincas_roses_bean_stalks")
m.addConstr(10*x0 + 10*x1 + 7*x3 <= 93, name="max_resilience_vincas_roses_chives")

# Resource constraints
m.addConstr(3*x0 <= 183, name="budget_vincas")
m.addConstr(10*x0 <= 172, name="resilience_vincas")
m.addConstr(10*x1 <= 172, name="resilience_roses")
m.addConstr(11*x2 <= 172, name="resilience_bean_stalks")
m.addConstr(7*x3 <= 172, name="resilience_chives")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Vincas: ", x0.varValue)
    print("Roses: ", x1.varValue)
    print("Bean Stalks: ", x2.varValue)
    print("Chives: ", x3.varValue)
else:
    print("No solution found")
