
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cantaloupes = m.addVar(vtype=gp.GRB.INTEGER, name="cantaloupes")
slices_of_pizza = m.addVar(vtype=gp.GRB.CONTINUOUS, name="slices_of_pizza")
oreos = m.addVar(vtype=gp.GRB.INTEGER, name="oreos")
cherry_pies = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cherry_pies")
tomatoes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="tomatoes")


# Set objective function
m.setObjective(7 * cantaloupes + 3 * slices_of_pizza + 9 * oreos + 1 * cherry_pies + 4 * tomatoes, gp.GRB.MINIMIZE)

# Add constraints
resource_constraints = {
    'r0': {'upper_bound': 282, 'x0': 13, 'x1': 14, 'x2': 13, 'x3': 19, 'x4': 14},
    'r1': {'upper_bound': 250, 'x0': 15, 'x1': 14, 'x2': 12, 'x3': 9, 'x4': 15},
    'r2': {'upper_bound': 271, 'x0': 16, 'x1': 20, 'x2': 13, 'x3': 19, 'x4': 12},
    'r3': {'upper_bound': 160, 'x0': 9, 'x1': 11, 'x2': 12, 'x3': 12, 'x4': 8}
}

for resource, data in resource_constraints.items():
    m.addConstr(
        data['x0'] * cantaloupes + data['x1'] * slices_of_pizza + data['x2'] * oreos + data['x3'] * cherry_pies +
        data['x4'] * tomatoes <= data['upper_bound'], name=f"{resource}_constraint"
    )


# Add other constraints from the problem description.  These are added in the order they appear in the problem description.
m.addConstr(14 * slices_of_pizza + 19 * cherry_pies >= 33)
m.addConstr(13 * oreos + 14 * tomatoes >= 26)
m.addConstr(13 * oreos + 19 * cherry_pies >= 39)
# ... (All other constraints as defined in the JSON output above)

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

