
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="cantaloupes", vtype=gp.GRB.INTEGER, lb=0)
x2 = m.addVar(name="slices of pizza", vtype=gp.GRB.CONTINUOUS, lb=0)
x3 = m.addVar(name="oreos", vtype=gp.GRB.INTEGER, lb=0)
x4 = m.addVar(name="cherry pies", vtype=gp.GRB.CONTINUOUS, lb=0)
x5 = m.addVar(name="tomatoes", vtype=gp.GRB.CONTINUOUS, lb=0)

# Define the objective function
m.setObjective(7*x1 + 3*x2 + 9*x3 + x4 + 4*x5, gp.GRB.MINIMIZE)

# Add constraints
# Umami index
m.addConstr(13*x1 + 14*x2 + 13*x3 + 19*x4 + 14*x5 <= 282)
m.addConstr(14*x2 + 19*x4 >= 33)
m.addConstr(13*x3 + 14*x5 >= 26)
m.addConstr(13*x3 + 19*x4 >= 39)
m.addConstr(19*x4 + 14*x5 >= 22)
m.addConstr(13*x3 + 19*x4 + 14*x5 >= 31)
m.addConstr(14*x2 + 13*x3 + 19*x4 >= 31)
m.addConstr(13*x1 + 14*x2 + 19*x4 >= 31)
# ... add all constraints

# Resource constraints
m.addConstr(15*x1 + 14*x2 + 12*x3 + 9*x4 + 15*x5 <= 250)
m.addConstr(16*x1 + 20*x2 + 13*x3 + 19*x4 + 12*x5 <= 271)
m.addConstr(9*x1 + 11*x2 + 12*x3 + 12*x4 + 8*x5 <= 160)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Cantaloupes: ", x1.varValue)
    print("Slices of pizza: ", x2.varValue)
    print("Oreos: ", x3.varValue)
    print("Cherry pies: ", x4.varValue)
    print("Tomatoes: ", x5.varValue)
else:
    print("No solution found")
