
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(vtype=gurobi.GRB.INTEGER, name='air_defense_batteries')
    x1 = model.addVar(vtype=gurobi.GRB.INTEGER, name='light_infantry_companies')
    x2 = model.addVar(vtype=gurobi.GRB.INTEGER, name='CBRN_platoons')
    x3 = model.addVar(vtype=gurobi.GRB.INTEGER, name='pathfinder_teams')

    # Define the objective function
    model.setObjective(2.9*x0 + 9.71*x1 + 3.61*x2 + 3.39*x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3*x0 + 15*x1 + 11*x2 + 11*x3 <= 208)
    model.addConstr(3*x0 + 21*x1 + 12*x2 + x3 <= 84)
    model.addConstr(11*x2 + 11*x3 >= 38)
    model.addConstr(15*x1 + 11*x3 >= 20)
    model.addConstr(3*x0 + 15*x1 >= 48)
    model.addConstr(3*x0 + 11*x2 >= 17)
    model.addConstr(15*x1 + 11*x2 + 11*x3 >= 40)
    model.addConstr(3*x0 + 11*x2 + 11*x3 >= 40)
    model.addConstr(3*x0 + 15*x1 + 11*x3 >= 40)
    model.addConstr(15*x1 + 11*x2 + 11*x3 >= 50)
    model.addConstr(3*x0 + 11*x2 + 11*x3 >= 50)
    model.addConstr(3*x0 + 15*x1 + 11*x3 >= 50)
    model.addConstr(21*x1 + 12*x2 >= 7)
    model.addConstr(12*x2 + x3 >= 16)
    model.addConstr(3*x0 + 12*x2 >= 8)
    model.addConstr(3*x0 + 21*x1 >= 13)
    model.addConstr(21*x1 + 12*x2 + x3 >= 18)
    model.addConstr(3*x0 + 21*x1 + x3 >= 18)
    model.addConstr(3*x0 + 12*x2 + x3 >= 18)
    model.addConstr(21*x1 + 12*x2 + x3 >= 19)
    model.addConstr(3*x0 + 21*x1 + x3 >= 19)
    model.addConstr(3*x0 + 12*x2 + x3 >= 19)
    model.addConstr(21*x1 + 12*x2 + x3 >= 11)
    model.addConstr(3*x0 + 21*x1 + x3 >= 11)
    model.addConstr(3*x0 + 12*x2 + x3 >= 11)
    model.addConstr(15*x1 + 11*x3 <= 181)
    model.addConstr(3*x0 + 11*x3 <= 177)
    model.addConstr(3*x0 + 15*x1 <= 133)
    model.addConstr(15*x1 + 11*x2 <= 93)
    model.addConstr(15*x1 + 11*x2 + 11*x3 <= 164)
    model.addConstr(3*x0 + 15*x1 + 11*x2 + 11*x3 <= 164)
    model.addConstr(3*x0 + 21*x1 <= 41)
    model.addConstr(21*x1 + 12*x2 <= 30)
    model.addConstr(12*x2 + x3 <= 43)
    model.addConstr(3*x0 + 21*x1 + 12*x2 + x3 <= 43)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Air defense batteries: ', x0.varValue)
        print('Light infantry companies: ', x1.varValue)
        print('CBRN platoons: ', x2.varValue)
        print('Pathfinder teams: ', x3.varValue)
    else:
        print('No optimal solution found')

solve_optimization_problem()
