
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    zinc = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
    b12 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="b12")
    b3 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="b3")
    c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="c")

    # Set objective function
    m.setObjective(7.5 * zinc + 5.18 * b12 + 3.52 * b3 + 8.91 * c, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(5 * zinc + 1 * b12 >= 36)
    m.addConstr(5 * zinc + 18 * b3 >= 19)
    m.addConstr(1 * b12 + 18 * b3 + 19 * c >= 29)
    m.addConstr(5 * zinc + 1 * b12 + 19 * c >= 29)
    m.addConstr(5 * zinc + 18 * b3 + 19 * c >= 29)
    m.addConstr(1 * b12 + 18 * b3 + 19 * c >= 42)
    m.addConstr(5 * zinc + 1 * b12 + 19 * c >= 42)
    m.addConstr(5 * zinc + 18 * b3 + 19 * c >= 42)
    m.addConstr(1 * b12 + 18 * b3 + 19 * c >= 32)
    m.addConstr(5 * zinc + 1 * b12 + 19 * c >= 32)
    m.addConstr(5 * zinc + 18 * b3 + 19 * c >= 32)
    m.addConstr(5 * zinc + 1 * b12 + 18 * b3 + 19 * c >= 32)
    m.addConstr(2 * b12 + 5 * c >= 69)
    m.addConstr(2 * b12 + 13 * b3 >= 61)
    m.addConstr(5 * zinc + 13 * b3 >= 64)
    m.addConstr(5 * zinc + 5 * c >= 30)
    m.addConstr(5 * zinc + 13 * b3 + 5 * c >= 77)
    m.addConstr(5 * zinc + 2 * b12 + 13 * b3 + 5 * c >= 77)
    m.addConstr(8 * b12 - 4 * b3 >= 0)
    m.addConstr(5 * zinc + 1 * b12 + 19 * c <= 100)
    m.addConstr(5 * zinc + 1 * b12 + 18 * b3 <= 194)
    m.addConstr(5 * zinc + 18 * b3 + 19 * c <= 74)
    m.addConstr(5 * zinc + 2 * b12 + 13 * b3 <= 279)
    m.addConstr(5 * zinc + 2 * b12 + 5 * c <= 292)
    m.addConstr(5 * zinc + 13 * b3 + 5 * c <= 166)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('zinc:', zinc.x)
        print('b12:', b12.x)
        print('b3:', b3.x)
        print('c:', c.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
