
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
x0 = model.addVar(lb=0, name="milligrams of zinc", vtype=gurobi.GRB.CONTINUOUS)
x1 = model.addVar(lb=0, name="milligrams of vitamin B12", vtype=gurobi.GRB.CONTINUOUS)
x2 = model.addVar(lb=0, name="milligrams of vitamin B3", vtype=gurobi.GRB.INTEGER)
x3 = model.addVar(lb=0, name="milligrams of vitamin C", vtype=gurobi.GRB.CONTINUOUS)

# Objective function
model.setObjective(7.5*x0 + 5.18*x1 + 3.52*x2 + 8.91*x3, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(5*x0 <= 194)
model.addConstr(5*x0 <= 316)
model.addConstr(x1 <= 194)
model.addConstr(2*x1 <= 316)
model.addConstr(18*x2 <= 194)
model.addConstr(13*x2 <= 316)
model.addConstr(19*x3 <= 194)
model.addConstr(5*x3 <= 316)
model.addConstr(5*x0 + x1 >= 36)
model.addConstr(5*x0 + 18*x2 >= 19)
model.addConstr(x1 + 18*x2 + 19*x3 >= 29)
model.addConstr(5*x0 + x1 + 19*x3 >= 29)
model.addConstr(5*x0 + 18*x2 + 19*x3 >= 29)
model.addConstr(x1 + 18*x2 + 19*x3 >= 42)
model.addConstr(5*x0 + x1 + 19*x3 >= 42)
model.addConstr(5*x0 + 18*x2 + 19*x3 >= 42)
model.addConstr(x1 + 18*x2 + 19*x3 >= 32)
model.addConstr(5*x0 + x1 + 19*x3 >= 32)
model.addConstr(5*x0 + 18*x2 + 19*x3 >= 32)
model.addConstr(5*x0 + x1 + 18*x2 + 19*x3 >= 32)
model.addConstr(2*x1 + 5*x3 >= 69)
model.addConstr(2*x1 + 13*x2 >= 61)
model.addConstr(5*x0 + 13*x2 >= 64)
model.addConstr(5*x0 + 5*x3 >= 30)
model.addConstr(5*x0 + 13*x2 + 5*x3 >= 77)
model.addConstr(5*x0 + 2*x1 + 13*x2 + 5*x3 >= 77)
model.addConstr(8*x1 - 4*x2 >= 0)
model.addConstr(5*x0 + x1 + 19*x3 <= 100)
model.addConstr(5*x0 + x1 + 18*x2 <= 194)
model.addConstr(5*x0 + 18*x2 + 19*x3 <= 74)
model.addConstr(5*x0 + 2*x1 + 13*x2 <= 279)
model.addConstr(5*x0 + 2*x1 + 5*x3 <= 292)
model.addConstr(5*x0 + 13*x2 + 5*x3 <= 166)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("milligrams of zinc: ", x0.varValue)
    print("milligrams of vitamin B12: ", x1.varValue)
    print("milligrams of vitamin B3: ", x2.varValue)
    print("milligrams of vitamin C: ", x3.varValue)
else:
    print("The model is infeasible")
